'
' Instances of this class represent a document.
'
Friend Class Document
    Inherits CompositeDocumentElement
    Private fname As String
    Private levels(0) As TocLevel

    ' name of the file this document is stored in
    Public ReadOnly Property FileName() As String
        Get
            Return fname
        End Get
    End Property

    ' no default
    Private Sub New()
    End Sub 'New

    ' create a document for this filename
    Public Sub New(ByVal f As String)
        fname = f
    End Sub 'New

    ' array of TocLevel objects
    Public ReadOnly Property TocLevels() As TocLevel()
        Get
            Dim myLevels(levels.Length) As TocLevel
            System.Array.Copy(levels, 0, myLevels, 0, levels.Length)
            Return levels
        End Get
    End Property
End Class 'Document